/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Node;

public class VWField
implements Serializable {
    protected String name;
    protected Object value;
    protected int mode;
    protected boolean systemField;
    protected boolean isArray;
    protected int fieldType;
    protected boolean altered = false;
    protected Vector alteredArray = null;
    protected String description = null;
    private static final long serialVersionUID = 7448L;
    protected static final String ROOT = "FLD";
    private static final String ATTR_NAME = "N";
    private static final String ATTR_MODE = "M";
    private static final String ATTR_VALUE = "V";
    private static final String ATTR_ISSYSTEM = "S";
    private static final String ATTR_TYPE = "T";

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 16:13:14  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.22  $";
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    protected Object getStoredValue() {
        if (this.fieldType == 64 && this.value != null) {
            if (this.isArray) {
                Object[] objList = (Object[])this.value;
                int sz = objList.length;
                String[] participantList = new String[sz];
                for (int i = 0; i < sz; ++i) {
                    participantList[i] = ((VWParticipant)objList[i]).getParticipantName();
                }
                return participantList;
            }
            return ((VWParticipant)this.value).getParticipantName();
        }
        return this.value;
    }

    public void setValue(Object newValue, boolean compareValue) {
        if (!this.systemField) {
            if (!compareValue) {
                if (!this.systemField) {
                    this.value = newValue;
                    this.altered = true;
                    if (this.value != null && this.value instanceof Object[] && ((Object[])this.value).length > 0) {
                        this.alteredArray = new Vector(((Object[])this.value).length);
                        for (int i = 0; i < ((Object[])this.value).length; ++i) {
                            this.alteredArray.addElement(new Boolean(true));
                        }
                    } else {
                        this.alteredArray = null;
                    }
                }
            } else if (newValue != null && newValue instanceof Object[] && ((Object[])newValue).length > 0) {
                int i;
                if (this.alteredArray == null) {
                    this.alteredArray = new Vector(((Object[])newValue).length);
                    for (i = 0; i < ((Object[])newValue).length; ++i) {
                        this.alteredArray.addElement(new Boolean(false));
                    }
                }
                if (this.value == null) {
                    this.altered = true;
                    this.value = newValue;
                    for (i = 0; i < ((Object[])this.value).length; ++i) {
                        this.alteredArray.insertElementAt(new Boolean(true), i);
                    }
                } else {
                    Object[] theNewValue = (Object[])newValue;
                    Object[] valueHolder = (Object[])this.value;
                    Vector<Object> theValue = new Vector<Object>(valueHolder.length);
                    for (int j = 0; j < valueHolder.length; ++j) {
                        theValue.insertElementAt(valueHolder[j], j);
                    }
                    int altsize = this.alteredArray.size();
                    for (int i2 = 0; i2 < theNewValue.length; ++i2) {
                        if (i2 < theValue.size()) {
                            if ((theValue == null || theNewValue[i2] != null) && (theValue != null && theValue.elementAt(i2) != null || theNewValue[i2] == null) && theValue.elementAt(i2).equals(theNewValue[i2])) continue;
                            this.altered = true;
                            theValue.setElementAt(theNewValue[i2], i2);
                            if (i2 < altsize) {
                                this.alteredArray.setElementAt(new Boolean(true), i2);
                                continue;
                            }
                            this.alteredArray.addElement(new Boolean(true));
                            continue;
                        }
                        this.altered = true;
                        theValue.addElement(theNewValue[i2]);
                        if (i2 < altsize) {
                            this.alteredArray.setElementAt(new Boolean(true), i2);
                            continue;
                        }
                        this.alteredArray.addElement(new Boolean(true));
                    }
                    if (theValue.size() > theNewValue.length) {
                        int i3;
                        this.altered = true;
                        int origsize = theValue.size();
                        int newsize = theNewValue.length;
                        int arrsize = this.alteredArray.size();
                        for (i3 = arrsize - 1; newsize - 1 < i3; --i3) {
                            this.alteredArray.removeElementAt(i3);
                        }
                        for (i3 = origsize - 1; newsize - 1 < i3; --i3) {
                            theValue.removeElementAt(i3);
                        }
                        theValue.trimToSize();
                        this.alteredArray.trimToSize();
                    }
                    if (theValue.size() < this.alteredArray.size()) {
                        int newsize = theValue.size();
                        int arrsize = this.alteredArray.size();
                        for (int i4 = arrsize - 1; newsize - 1 < i4; --i4) {
                            this.alteredArray.removeElementAt(i4);
                        }
                        this.alteredArray.trimToSize();
                    }
                    switch (this.fieldType) {
                        case 4: {
                            Object[] btmp = new Boolean[theValue.size()];
                            theValue.copyInto(btmp);
                            this.value = btmp;
                            break;
                        }
                        case 1: {
                            Object[] itmp = new Integer[theValue.size()];
                            theValue.copyInto(itmp);
                            this.value = itmp;
                            break;
                        }
                        case 8: {
                            Object[] dtmp = new Double[theValue.size()];
                            theValue.copyInto(dtmp);
                            this.value = dtmp;
                            break;
                        }
                        case 16: {
                            Object[] ttmp = new Date[theValue.size()];
                            theValue.copyInto(ttmp);
                            this.value = ttmp;
                            break;
                        }
                        case 2: 
                        case 32: {
                            Object[] stmp = new String[theValue.size()];
                            theValue.copyInto(stmp);
                            this.value = stmp;
                            break;
                        }
                        case 64: {
                            Object[] pxList = new VWParticipant[theValue.size()];
                            theValue.copyInto(pxList);
                            this.value = pxList;
                            break;
                        }
                        default: {
                            Object[] otmp = new Object[theValue.size()];
                            theValue.copyInto(otmp);
                            this.value = otmp;
                            break;
                        }
                    }
                }
            } else if (this.value == null && newValue != null || this.value != null && newValue == null || this.value != null && !this.value.equals(newValue)) {
                this.value = newValue;
                this.altered = true;
                this.alteredArray = null;
            }
        }
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isSystemField() {
        return this.systemField;
    }

    public int getType() {
        return this.fieldType;
    }

    public boolean hasBeenAltered() {
        return this.altered;
    }

    public void resetAlteredFlag() {
        this.altered = false;
        this.alteredArray = null;
    }

    public Boolean[] hasBeenAlteredArray() {
        Object[] fa = null;
        if (this.alteredArray != null && this.alteredArray.size() > 0) {
            fa = new Boolean[this.alteredArray.size()];
            this.alteredArray.copyInto(fa);
        }
        return fa;
    }

    public int getMode() {
        return this.mode;
    }

    public String getDescription() {
        return this.description;
    }

    public VWField(String field_name, int field_mode, Object field_value, boolean system_field, int field_type, boolean is_array, String field_description) {
        this.name = field_name;
        this.mode = field_mode;
        this.value = field_value;
        this.systemField = system_field;
        this.fieldType = field_type;
        this.isArray = is_array;
        this.description = field_description;
    }

    public VWField(String field_name, int field_mode, Object field_value, boolean system_field) {
        this.name = field_name;
        this.mode = field_mode;
        this.value = field_value;
        this.systemField = system_field;
        this.fieldType = 0;
    }

    public VWField(VWField fieldToCopy) {
        this.name = fieldToCopy.name;
        this.mode = fieldToCopy.mode;
        this.value = fieldToCopy.value;
        this.systemField = fieldToCopy.systemField;
        this.fieldType = fieldToCopy.fieldType;
        this.isArray = fieldToCopy.isArray;
        this.description = fieldToCopy.description;
    }

    protected static String value2String(Object val, int fType) {
        switch (fType) {
            case 16: 
            case 256: {
                if (!(val instanceof Date)) break;
                return Long.toString(((Date)val).getTime());
            }
        }
        return val.toString();
    }

    protected void asString4LastRecord(StringBuffer buf) throws Exception {
        if (this.isArray) {
            return;
        }
        if (this.value == null) {
            return;
        }
        if (this.fieldType == 32 || this.fieldType == 64) {
            return;
        }
        buf.append("<").append(ROOT).append(" ").append(ATTR_NAME).append("=\"").append(XMLHelper.toXMLString(this.name)).append("\" ").append(ATTR_ISSYSTEM).append("=\"").append(this.systemField).append("\" ").append(ATTR_TYPE).append("=\"").append(this.fieldType).append("\" ").append(ATTR_VALUE).append("=\"").append(XMLHelper.toXMLString(VWField.value2String(this.value, this.fieldType))).append("\"/>\n");
    }

    protected static Object string2Value(String s, int fieldType) {
        switch (fieldType) {
            case 4: {
                return new Boolean(s);
            }
            case 8: {
                return new Double(s);
            }
            case 1: {
                return new Integer(s);
            }
            case 16: 
            case 256: {
                return new Date(Long.parseLong(s));
            }
        }
        return s;
    }

    protected static VWField fromXMLNode(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        if (!node.getNodeName().equals(ROOT)) {
            return null;
        }
        String name = VWXMLWrapper.getNodeAttribute(node, ATTR_NAME);
        if (name == null) {
            return null;
        }
        String s = null;
        boolean isSystem = false;
        s = VWXMLWrapper.getNodeAttribute(node, ATTR_ISSYSTEM);
        if (s == null) {
            return null;
        }
        isSystem = new Boolean(s);
        int fieldType = 0;
        s = VWXMLWrapper.getNodeAttribute(node, ATTR_TYPE);
        if (s == null) {
            return null;
        }
        fieldType = Integer.parseInt(s);
        Object val = null;
        s = VWXMLWrapper.getNodeAttribute(node, ATTR_VALUE);
        if (s == null) {
            return null;
        }
        val = VWField.string2Value(s, fieldType);
        return new VWField(name, 1, val, isSystem, fieldType, false, "");
    }
}

